/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.vo.MosPVo;
import jp.mosp.system.dto.MCodeDto;

public class HolidayMasterCardVo extends MosPVo {

	private static final long serialVersionUID = -1523597184920140308L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL	= "/jsp/system/holidayMasterCard.jsp";
	private static final String EXTRA_JS		= "/pub/system/js/holidayMasterCard.js";
	private static final String EXTRA_CSS		= "/pub/system/css/holidayMasterCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_HOLIDAY_MASTER;

	// 萔
	public static final int MODE_INSERT = 0;
	public static final int MODE_UPDATE = 1;
	public static final int MODE_SYSTEM = 2;

	// p[^	
	public static final String PRM_TXT_HOLIDAY_YEAR		= "txtHolidayYear";
	public static final String PRM_PLT_HOLIDAY_MONTH		= "pltHolidayMonth";
	public static final String PRM_PLT_HOLIDAY_DAY		= "pltHolidayDay";
	public static final String PRM_TXT_HOLIDAY_NAME		= "txtHolidayName";

	// tB[h
	private String	txtHolidayYear;
	private String	pltHolidayMonth;
	private String	pltHolidayDay;
	private String	txtHolidayName;

	// [h(0FVKo^A1FXVA2F폜)
	private int mode;

	// tB[hyѐ	
	public static final String NAM_HOLIDAY_DATE		= CommonConst.NAM_DATE;
	public static final String NAM_HOLIDAY_YEAR		= CommonConst.NAM_YEAR;
	public static final String NAM_HOLIDAY_MONTH		= CommonConst.NAM_MONTH;
	public static final String NAM_HOLIDAY_DAY		= CommonConst.NAM_DAY;
	public static final String NAM_HOLIDAY_NAME		= CommonConst.NAM_COMMON_MEISYO;

	public static final int	LEN_YEAR	= CommonConst.LEN_YEAR;
	public static final int	LEN_NAME	= 50;

	// v_E
	public String[][] aryPltMonth;
	public String[][] aryPltDay;

	/**
	 * RXgN^
	 */
	public HolidayMasterCardVo() {
		super();
		mode = 0;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		setTxtHolidayYear("");
		setTxtHolidayName("");
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		txtHolidayYear	= request.getParameter(PRM_TXT_HOLIDAY_YEAR);
		pltHolidayMonth	= request.getParameter(PRM_PLT_HOLIDAY_MONTH);
		pltHolidayDay	= request.getParameter(PRM_PLT_HOLIDAY_DAY);
		txtHolidayName	= request.getParameter(PRM_TXT_HOLIDAY_NAME);
	}

	/**
	 * tB[hݒ
	 * @param dto [U[Xg
	 */
	public void setFields(MCodeDto dto) {
		// f[^̐ݒ
		String holiday = dto.getTCode();
		if (holiday.startsWith("0")
				|| holiday.startsWith("1")) {
			txtHolidayYear	= "";
			pltHolidayMonth	= util.removeZero(holiday.split(CommonConst.SEPARATOR_DATE)[0]);
			pltHolidayDay	= util.removeZero(holiday.split(CommonConst.SEPARATOR_DATE)[1]);
		} else {
			txtHolidayYear	= String.valueOf(MospUtility.getYear(util.convStringDateToDate(dto.getTCode())));
			pltHolidayMonth	= String.valueOf(MospUtility.getMonth(util.convStringDateToDate(dto.getTCode())));
			pltHolidayDay	= String.valueOf(MospUtility.getDay(util.convStringDateToDate(dto.getTCode())));
		}
		txtHolidayName	= dto.getTName();
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtHolidayName	, NAM_HOLIDAY_NAME	, PRM_TXT_HOLIDAY_NAME);
		// 񒷊mF
		checkLength  (txtHolidayYear	, LEN_YEAR	, NAM_HOLIDAY_YEAR	, PRM_TXT_HOLIDAY_YEAR);
		checkLength  (txtHolidayName	, LEN_NAME	, NAM_HOLIDAY_NAME	, PRM_TXT_HOLIDAY_NAME);
		// tmF
		if (!txtHolidayYear.equals("")) {
			checkDate(
					Integer.parseInt(txtHolidayYear),
					Integer.parseInt(pltHolidayMonth),
					Integer.parseInt(pltHolidayDay), NAM_HOLIDAY_DATE, PRM_TXT_HOLIDAY_YEAR);
		} else {
			checkDate(
					MospUtility.getYear(util.getSystemDate()),
					Integer.parseInt(pltHolidayMonth),
					Integer.parseInt(pltHolidayDay), NAM_HOLIDAY_DATE, PRM_TXT_HOLIDAY_YEAR);
		}
		// ÓmFI
		endValidation();
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MCodeDto dto) {
		dto.setTId(CommonConst.NAM_HOLIDAY);
		if (!txtHolidayYear.equals("")) {
			dto.setTCode(util.convStringDateFormatted(txtHolidayYear, pltHolidayMonth, pltHolidayDay));			
		} else {
			dto.setTCode(
					util.addZero(pltHolidayMonth)
					+ CommonConst.SEPARATOR_DATE
					+ util.addZero(pltHolidayDay));
		}
		dto.setTName(txtHolidayName);
		dto.setTChange(CommonConst.NAM_COMMON_STRING_INITIAL_VALUE);
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public void setTxtHolidayYear	(String txtHolidayYear	) { this.txtHolidayYear		= txtHolidayYear	; }
	public void setPltHolidayMonth	(String pltHolidayMonth	) { this.pltHolidayMonth	= pltHolidayMonth	; }
	public void setPltHolidayDay	(String pltHolidayDay	) { this.pltHolidayDay		= pltHolidayDay		; }
	public void setTxtHolidayName	(String txtHolidayName	) { this.txtHolidayName		= txtHolidayName	; }

	public String getTxtHolidayYear()	{ return txtHolidayYear		; }
	public String getPltHolidayMonth()	{ return pltHolidayMonth	; }
	public String getPltHolidayDay()	{ return pltHolidayDay		; }
	public String getTxtHolidayName()	{ return txtHolidayName		; }

	public String getEscTxtHolidayYear() { return escapeHTML(txtHolidayYear)	; }
	public String getEscTxtHolidayName() { return escapeHTML(txtHolidayName)	; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
